//------------------------------------------------------------------------------
// Tumar CSP
// Copyright (c) 2011 Scientific Lab. Gamma Technologies. All rights reserved.
// SDK
// Get info from TimeStamp
//------------------------------------------------------------------------------
#include "ex_util.h"
//------------------------------------------------------------------------------
#define TSP_REP_FILE "tsp_rep.bin"
//------------------------------------------------------------------------------
//           PKCS7
// :
// 1.     
//------------------------------------------------------------------------------
unsigned char WBuf[8196],wb[512];
//------------------------------------------------------------------------------
int main(void)
{
 int code;
 HCRYPTPROV hProv=0;
 HCRYPTHASH hHash;
 DWORD dw,len,sz;

 //  
 code=LoadTumarCSP((char*)CSP_LIB); if (code) {printf("Load CSP error: %d\n",code); return 1;}
 //
 //  TimeStamp
 if (getFileLen(TSP_REP_FILE,    &sz)) {printf("getFileLen error\r\n"); return 1;}
 if (readFile  (TSP_REP_FILE,WBuf,sz)) {printf("readFile error\r\n");   return 1;}
 //
 //   CSP
 if (!CPAcquireContext(&hProv,NULL,CRYPT_VERIFYCONTEXT,NULL)) {
   printf("CPAcquireContext Error: %0X\n",GetLastErrorCSP(0));
   return 1;
 }
 //  -
 if (!CPCreateHash(hProv,CALG_TGR3411,0,0,&hHash)) {
   printf("CPCreateHash Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //     
 if (!CPSetHashParam(hProv,hHash,HP_TSTAMP_BODY,WBuf,0)) {
   printf("CPSetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //   
 len=sizeof(dw);
 if (!CPGetHashParam(hProv,hHash,HP_TSTAMP_STSTUS,(BYTE*)&dw,&len,0)) {
   printf("CPGetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 printf("Status = %d\r\n",dw);

 //      TSP
 len=sizeof(wb);
 if (!CPGetHashParam(hProv,hHash,HP_PKCS7_SI_SN,wb,&len,0)) {
   printf("CPGetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 printf("SN (size=%d) : %02X %02X ...\r\n",len,wb[0],wb[1]);

 if (dw==0) {
   //  
   len=sizeof(wb);
   if (!CPGetHashParam(hProv,hHash,HP_TSTAMP_HASH,wb,&len,0)) {
     printf("CPGetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
     return 1;
   }
   printf("Hash (size=%d) = %02X %02X ...\r\n",len, wb[0],wb[1]);
   //  
   len=sizeof(wb);
   if (!CPGetHashParam(hProv,hHash,HP_TSTAMP_POLICIE,wb,&len,0)) {
     printf("CPGetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
     return 1;
   }
   wb[len]=0;
   printf("Policie = %s\r\n",(char*)wb);
   //  
   len=sizeof(wb);
   if (!CPGetHashParam(hProv,hHash,HP_TSTAMP_TIME,wb,&len,0)) {
     printf("CPGetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
     return 1;
   }
   wb[len]=0;
   printf("Time = %s\r\n",(char*)wb);
   //   
   len=sizeof(wb);
   if (!CPGetHashParam(hProv,hHash,HP_TSTAMP_SN,wb,&len,0)) {
     printf("CPGetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
     return 1;
   }
   printf("SN (size=%d) = %02X %02X ...\r\n",len,wb[0],wb[1]);
   //  NONCE
   len=sizeof(wb);
   if (!CPGetHashParam(hProv,hHash,HP_TSTAMP_NONCE,wb,&len,0)) {
     printf("CPGetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
     return 1;
   }
   printf("Nonce (size=%d) = %02X %02X ...\r\n",len,wb[0],wb[1]);
   //  DN
   len=sizeof(wb);
   if (!CPGetHashParam(hProv,hHash,HP_TSTAMP_DN,wb,&len,0)) {
     printf("CPGetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
     return 1;
   }
   wb[len]=0;
   printf("DN = [%s]\r\n",(char*)wb);
 }
 CPDestroyHash(hProv,hHash);
 //   
 len=sizeof(wb);
 if (!CPGetProvParam(hProv,PP_SYS_TIME,wb,&len,0)) {
   printf("CPGetProvParam(PP_SYS_TIME) Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 wb[len]=0;
 printf("SYS TIME = [%s]\r\n",(char*)wb);
 //   CSP
 CPReleaseContext(hProv,0);
 printf("OK\n");
 return 0;
}
//------------------------------------------------------------------------------
